/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import me.angel.challenges6t4.player.PlayerNumberManager;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayerSwapChallenge
extends Challenge {
    private static long lastSwapTime = 0L;
    private static final long DAMAGE_COOLDOWN_MS = 5000L;
    private static long ticksUntilNextSwap = 0L;
    private static boolean timerStarted = false;
    private static boolean wasTimerStarted = false;
    private static final String SETTING_TIMER_MODE = "timer_mode";
    private static final String SETTING_TIMER_INTERVAL = "timer_interval";

    public PlayerSwapChallenge() {
        super("player_swap", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.player_swap.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.player_swap.description"), true, Challenge.MultiplayerStatus.MULTIPLAYER_ONLY);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_TIMER_MODE)) {
            ChallengeSettings.setBooleanOption(this.getId(), SETTING_TIMER_MODE, false);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_TIMER_INTERVAL)) {
            ChallengeSettings.setIntOption(this.getId(), SETTING_TIMER_INTERVAL, 5);
        }
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
        lastSwapTime = 0L;
        ticksUntilNextSwap = 0L;
        timerStarted = false;
        wasTimerStarted = false;
    }

    @Override
    public void onDisable() {
        lastSwapTime = 0L;
        ticksUntilNextSwap = 0L;
        timerStarted = false;
        wasTimerStarted = false;
    }

    private boolean isOnDamageCooldown() {
        long currentTime = System.currentTimeMillis();
        return currentTime - lastSwapTime < 5000L;
    }

    private void sendTimerMessage(class_3218 world, long ticksLeft) {
        if (!ChallengeSettings.getBooleanOption(this.getId(), "show_timer_messages", true)) {
            return;
        }
        long seconds = ticksLeft / 20L;
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        String message = String.format("%02d:%02d", minutes, remainingSeconds);
        class_2583 style = seconds <= 10L ? class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)) : (seconds <= 30L ? class_2583.field_24360.method_10977(class_124.field_1054) : class_2583.field_24360.method_10977(class_124.field_1060));
        for (class_3218 serverWorld : world.method_8503().method_3738()) {
            for (class_1657 player : serverWorld.method_18456()) {
                int playerNumber = PlayerNumberManager.getPlayerNumber(player);
                if (playerNumber != 1 && playerNumber != 2) continue;
                player.method_7353((class_2561)class_2561.method_43470((String)message).method_10862(style), true);
            }
        }
    }

    public void onPlayerDamage(class_1657 player, class_1282 source, float amount) {
        if (ChallengeSettings.getBooleanOption(this.getId(), SETTING_TIMER_MODE, false)) {
            return;
        }
        int playerNumber = PlayerNumberManager.getPlayerNumber(player);
        if (playerNumber != 1 && playerNumber != 2) {
            return;
        }
        if (this.isOnDamageCooldown()) {
            return;
        }
        this.swapPlayers((class_3222)player);
    }

    public void tick(class_3218 world) {
        if (!this.isEnabled() || !ChallengeSettings.getBooleanOption(this.getId(), SETTING_TIMER_MODE, false) || world.method_27983() != class_1937.field_25179) {
            return;
        }
        boolean hasPlayer1 = false;
        boolean hasPlayer2 = false;
        for (Object serverWorld : world.method_8503().method_3738()) {
            for (Object player : serverWorld.method_18456()) {
                int playerNumber = PlayerNumberManager.getPlayerNumber((class_1657)player);
                if (playerNumber == 1) {
                    hasPlayer1 = true;
                }
                if (playerNumber != 2) continue;
                hasPlayer2 = true;
            }
        }
        if (hasPlayer1 && hasPlayer2 && !timerStarted && !wasTimerStarted) {
            int intervalMinutes = ChallengeSettings.getIntOption(this.getId(), SETTING_TIMER_INTERVAL, 5);
            ticksUntilNextSwap = intervalMinutes * 60 * 20;
            timerStarted = true;
            wasTimerStarted = true;
            this.sendTimerMessage(world, ticksUntilNextSwap);
            for (Object serverWorld : world.method_8503().method_3738()) {
                for (class_1657 player : serverWorld.method_18456()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Debug: Timer started with " + ticksUntilNextSwap + " ticks")), false);
                }
            }
            return;
        }
        if (!timerStarted) {
            return;
        }
        if (--ticksUntilNextSwap % 20L == 0L) {
            this.sendTimerMessage(world, ticksUntilNextSwap);
            for (Object serverWorld : world.method_8503().method_3738()) {
                for (Object player : serverWorld.method_18456()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Debug: Timer running - " + ticksUntilNextSwap + " ticks left")), false);
                }
            }
        }
        if (ticksUntilNextSwap <= 0L) {
            class_3222 player1 = null;
            for (Object serverWorld : world.method_8503().method_3738()) {
                for (class_1657 player : serverWorld.method_18456()) {
                    if (PlayerNumberManager.getPlayerNumber(player) != 1) continue;
                    player1 = (class_3222)player;
                    break;
                }
                if (player1 == null) continue;
                break;
            }
            if (player1 != null) {
                for (Object serverWorld : world.method_8503().method_3738()) {
                    for (class_1657 p : serverWorld.method_18456()) {
                        p.method_7353((class_2561)class_2561.method_43470((String)"Debug: Attempting swap"), false);
                    }
                }
                this.swapPlayers(player1);
                int intervalMinutes = ChallengeSettings.getIntOption(this.getId(), SETTING_TIMER_INTERVAL, 5);
                ticksUntilNextSwap = intervalMinutes * 60 * 20;
                wasTimerStarted = false;
                for (class_3218 serverWorld : world.method_8503().method_3738()) {
                    for (class_1657 p : serverWorld.method_18456()) {
                        p.method_7353((class_2561)class_2561.method_43470((String)("Debug: Swap completed, timer reset to " + ticksUntilNextSwap)), false);
                    }
                }
            }
        }
    }

    private void swapPlayers(class_3222 initiator) {
        int initiatorNumber = PlayerNumberManager.getPlayerNumber((class_1657)initiator);
        class_3222 otherPlayer = null;
        for (class_3218 serverWorld : initiator.method_5682().method_3738()) {
            for (class_1657 p : serverWorld.method_18456()) {
                int otherNumber = PlayerNumberManager.getPlayerNumber(p);
                if (otherNumber != 1 && otherNumber != 2 || otherNumber == initiatorNumber) continue;
                otherPlayer = (class_3222)p;
                break;
            }
            if (otherPlayer == null) continue;
            break;
        }
        if (otherPlayer != null) {
            class_243 pos1 = initiator.method_19538();
            class_243 pos2 = otherPlayer.method_19538();
            float yaw1 = initiator.method_36454();
            float pitch1 = initiator.method_36455();
            float yaw2 = otherPlayer.method_36454();
            float pitch2 = otherPlayer.method_36455();
            otherPlayer.method_6082(pos1.field_1352, pos1.field_1351, pos1.field_1350, true);
            otherPlayer.method_36456(yaw1);
            otherPlayer.method_36457(pitch1);
            initiator.method_6082(pos2.field_1352, pos2.field_1351, pos2.field_1350, true);
            initiator.method_36456(yaw2);
            initiator.method_36457(pitch2);
            if (!ChallengeSettings.getBooleanOption(this.getId(), SETTING_TIMER_MODE, false)) {
                lastSwapTime = System.currentTimeMillis();
            }
        }
    }
}

